// Generated by CoffeeScript 1.6.2
(function() {
  'use strict';  maApp.controller('mgPostcalcCtrl', function($scope, AppData, lang, ma) {
    var setFocus;

    $scope.AppData = AppData;
    $scope.lang = lang.Current;
    lang = $scope.lang;
    $scope.$on("appDataChanged", function(msg, data) {
      AppData.PostcalcGridData = data;
      $scope.PostcalcGridLoad(AppData.PostcalcGridData);
      return $scope.$digest();
    });
    $scope.$on("gridDataChanged", function(msg, row, cell, fldName, value) {
      return $scope.sumCalculate();
    });
    $scope.Callback = function(msg) {
      if (window.ma.isDemo()) {
        return alert(lang("Callback is not in use in demo web-page."));
      } else {
        return window.ma.Callback(msg);
      }
    };
    $scope.LoadData = function(loadDemodata) {
      if (loadDemodata === true) {
        return $scope.PostcalcGridLoad(window.ma_app.exampleData());
      } else {
        return $scope.Callback("setData");
        /*
        if AppData.PostcalcGridData
          $scope.PostcalcGridLoad(AppData.PostcalcGridData
          $scope.$digest()
        else
          alert("AppData.PostcalcGridData has not been set, press again to load 4D data")
          data = window.ma_app.exampleData()
          #data.wo_kTbl.names[1] = "4D työmäär."
          data.wo_kTbl.arrays[1][0] = "4D DATA!!!"
          data.wma_kTbl.arrays[2][0] = "4D DATA fake!!!"
          data.wma_kTbl.arrays[2][1] = "4D DATA fake!!!"
          #data.wma_kTbl.arrays.splice(2, 1) # remove third array
          dataStr = angular.toJson(data)
          window.ma.FormEvent("SetData", dataStr)
        */

      }
    };
    $scope.woStateArr = [
      {
        text: "Ei Kuormitettu",
        value: "EK",
        href: "#"
      }, {
        text: "Kuormitettu",
        value: "KU",
        href: "#"
      }, {
        text: "Aloitettu",
        value: "AL",
        href: "#"
      }, {
        text: "Lopetettu",
        value: "LT",
        href: "#"
      }, {
        text: "Pysäytetty",
        value: "PY",
        href: "#"
      }, {
        text: "Peruutettu",
        value: "PE",
        href: "#"
      }
    ];
    $scope.woPricingArr = [
      {
        text: "Ei hinnoitella",
        value: 0,
        href: "#"
      }, {
        text: "Hinnoiteltava",
        value: 1,
        href: "#"
      }, {
        text: "Jälkilaskettu",
        value: 2,
        href: "#"
      }, {
        text: "Hinnoiteltu",
        value: 3,
        href: "#"
      }
    ];
    $scope.InputVarHeadersSet = function(data) {
      var fld, i, rec, _results;

      if (!$scope.hdr) {
        $scope.hdr = {};
      }
      i = 0;
      _results = [];
      while (i < data.columns.length) {
        rec = data.columns[i];
        fld = rec.field;
        $scope.hdr[fld] = rec.name;
        _results.push(i = i + 1);
      }
      return _results;
    };
    $scope.InputVarValuesSet = function(data, idx) {
      var rec, rowData, _i, _len, _ref, _results;

      if (!$scope.fld) {
        $scope.fld = {};
      }
      if (data.data.length > 0) {
        _ref = data.columns;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          rec = _ref[_i];
          rowData = data.data[idx];
          _results.push($scope.fld[rec.field] = rowData[rec.field]);
        }
        return _results;
      }
    };
    $scope.PostcalcGridLoad = function(data) {
      var allData, defaultColumnOptios, defaultGridOptios, gridDataShow, gridWmaData, gridWoData;

      allData = ma.ArrApJsonToObjectJson(data, data.grid, true);
      gridDataShow = ma.ArrApJsonToObjectJson(data, data.grid, false);
      gridWoData = gridDataShow.wo_kTbl;
      gridWmaData = gridDataShow.wma_kTbl;
      ma.TextToDateParse(gridWoData);
      ma.TextToDateParse(gridWmaData);
      ma.SlickDefaultFormatterSet(gridWoData.columns);
      ma.SlickDefaultFormatterSet(gridWmaData.columns);
      ma.JsonAttributesAdd(gridWoData.columns, {
        formatter: ma.SlickWeekdayFormatter,
        type: "",
        field: "wcap_alWeekday"
      });
      defaultGridOptios = {
        rowHeight: 23,
        editable: true,
        enableAddRow: false,
        enableColumnReorder: false,
        autoEdit: false,
        syncColumnCellResize: true
      };
      defaultColumnOptios = {
        sortable: true,
        resizable: true,
        focusable: true,
        rerenderOnResize: true,
        selectable: true,
        editor: Slick.Editors.Text
      };
      ma.JsonAttributesAdd(gridWmaData.columns, defaultColumnOptios);
      gridWmaData.options = defaultGridOptios;
      defaultColumnOptios.sortable = false;
      defaultColumnOptios.focusable = false;
      defaultColumnOptios.selectable = false;
      ma.JsonAttributesAdd(gridWoData.columns, defaultColumnOptios);
      gridWoData.options = defaultGridOptios;
      $scope.gridWoData = gridWoData;
      $scope.gridWoDataRows = ma.clone($scope.gridWoData.data);
      $scope.gridWoData.data.length = 1;
      $scope.gridWmaData = gridWmaData;
      $scope.wo_AllData = allData.wo_kTbl;
      $scope.wma_AllData = allData.wma_kTbl;
      $scope.wo_AllRowIdx = 0;
      $scope.wma_AllRowIdx = 0;
      $scope.InputVarHeadersSet($scope.wo_AllData);
      $scope.InputVarValuesSet($scope.wo_AllData, $scope.wo_AllRowIdx);
      $scope.InputVarHeadersSet($scope.wma_AllData);
      $scope.InputVarValuesSet($scope.wma_AllData, $scope.wma_AllRowIdx);
      if ($scope.wo_AllData.data.length > 0) {
        $scope.woHeaderPop = $scope.wo_AllData.data[0];
      }
      if ($scope.woPricingArr.length > 0) {
        $scope.woPricingStatePop = $scope.woPricingArr[0];
      }
      return $scope.sumCalculate();
    };
    $scope.sumCalculate = function() {
      var cost_total, cost_total_sum, cost_unit, cost_unit_sum, rec, sales_total, sales_total_sum, sales_unit, sales_unit_sum, _i, _len, _ref;

      cost_unit = 0;
      cost_unit_sum = 0;
      sales_unit = 0;
      sales_unit_sum = 0;
      cost_total = 0;
      cost_total_sum = 0;
      sales_total = 0;
      sales_total_sum = 0;
      _ref = $scope.gridWmaData.data;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        rec = _ref[_i];
        if (rec.wo_mat_arActCostPrice_Unit !== 0) {
          cost_unit = rec.wo_mat_arActCostPrice_Unit;
        } else {
          cost_unit = rec.wo_mat_arEstimCostPrice_Unit;
        }
        if (rec.wo_mat_arActSalesPrice_Unit !== 0) {
          sales_unit = rec.wo_mat_arActSalesPrice_Unit;
        } else {
          sales_unit = rec.wo_mat_arEstimSalesPrice_Unit;
        }
        if (rec.wo_mat_arNewAmount !== 0) {
          cost_total = cost_unit * rec.wo_mat_arNewAmount;
          sales_total = sales_unit * rec.wo_mat_arNewAmount;
        } else if (rec.wo_mat_arActAmount1 !== 0) {
          cost_total = cost_unit * rec.wo_mat_arActAmount1;
          sales_total = sales_unit * rec.wo_mat_arActAmount1;
        } else {
          cost_total = cost_unit * rec.wo_mat_arEstimAmount;
          sales_total = sales_unit * rec.wo_mat_arEstimAmount;
        }
        rec.wo_mat_arActCostPrice_Unit = cost_unit;
        rec.wo_mat_arActSalesPrice_Unit = sales_unit;
        rec.wo_mat_arActCostPrice = cost_total;
        rec.wo_mat_arActSalesPrice = sales_total;
        cost_unit_sum += cost_unit;
        sales_unit_sum += sales_unit;
        cost_total_sum += cost_total;
        sales_total_sum += sales_total;
      }
      $scope.wo_mat_rActCostPrice_UnitSum = cost_unit_sum.toFixed(2);
      $scope.wo_mat_rActSalesPrice_UnitSum = sales_unit_sum.toFixed(2);
      $scope.wo_mat_rActCostPriceSum = cost_total_sum.toFixed(2);
      return $scope.wo_mat_rActSalesPriceSum = sales_total_sum.toFixed(2);
    };
    $scope.fldFocus = "";
    setFocus = function(fldName) {
      return $scope.fldFocus = fldName;
    };
    $scope.woPricingStatePopChanged = function() {
      var el, txt;

      txt = $scope.woPricingStatePop.value;
      txt = txt + ". " + $scope.woPricingStatePop.text;
      el = angular.element("#wo_arSales_Price__unit");
      if ($scope.woPricingStatePop.value > 0) {
        el.attr("disabled", false);
        return setFocus("wo_arSales_Price__unit");
      } else {
        el.attr("disabled", true);
        return setFocus("");
      }
    };
    return $scope.woHeaderPopChanged = function() {
      $scope.wo_AllRowIdx = $scope.woHeaderPop.id - 1;
      $scope.InputVarValuesSet($scope.wo_AllData, $scope.wo_AllRowIdx);
      $scope.gridWoData.data[0] = $scope.gridWoDataRows[$scope.wo_AllRowIdx];
      return $scope.$broadcast("refresh-ma-grid", "gridWoData");
    };
  });

}).call(this);

/*
//@ sourceMappingURL=mgPostcalc.map
*/
